#include "iic.h"
#define write 0
#define read  1
float F_value=0;
//char display_String[20]={0};//ʾõַ4λʾ
float Humiture[4];

u8 Humiture_buff1[20];

/****************************************************************************
* Function Name  : IIC_Config
* Description    : ʼGPIO.
* Input          : None
* Output         : None
* Return         : None
****************************************************************************/
void I2C_INIT()
{
	
	
	GPIO_InitTypeDef GPIO_InitStructure;	
	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA,ENABLE);
//RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1,ENABLE);
	//GPIO_InitStructure.GPIO_Pin=I2C_SCL|I2C_SDA;
	GPIO_InitStructure.GPIO_Pin=I2C_SDA;
	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_10MHz;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_PP;
	GPIO_Init(GPIOA,&GPIO_InitStructure);
	
		
	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA,ENABLE);
	GPIO_InitStructure.GPIO_Pin=I2C_SCL;
	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_10MHz;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
	GPIO_Init(GPIOA,&GPIO_InitStructure);

	I2C_SCL_H;
	I2C_SDA_H;
	
	

}

/*******************************************************************************
*            : I2C_SDA_OUT
* 		   : SDA	   
*              : 
*              : 
*******************************************************************************/
void I2C_SDA_OUT()
{
    GPIO_InitTypeDef GPIO_InitStructure;	
	
	GPIO_InitStructure.GPIO_Pin=I2C_SDA;
	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_10MHz;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
	GPIO_Init(GPIOA,&GPIO_InitStructure);
}

/*******************************************************************************
*            : I2C_SDA_IN
* 		   : SDA	   
*              : 
*              : 
*******************************************************************************/
void I2C_SDA_IN(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;	
	
	GPIO_InitStructure.GPIO_Pin=I2C_SDA;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_AF_OD;
	GPIO_Init(GPIOA,&GPIO_InitStructure);
}


void I2C_SDA_in(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;	
	
	GPIO_InitStructure.GPIO_Pin=I2C_SDA;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_IPU;
	GPIO_Init(GPIOA,&GPIO_InitStructure);
}
//ʼź
void I2C_StarT(void)
{
    I2C_SDA_OUT();
	
	I2C_SDA_H;
	I2C_SCL_H;
	delay_us(5);
	I2C_SDA_L;
	delay_us(6);
	I2C_SCL_L;
}

//ֹͣź
void I2C_StoP(void)
{
   I2C_SDA_OUT();

   I2C_SCL_L;
   I2C_SDA_L;
   I2C_SCL_H;
   delay_us(6);
   I2C_SDA_H;
   delay_us(6);
}

//ӦźACK
void I2C_Ack(void)
{
   I2C_SCL_L;
   I2C_SDA_OUT();
   I2C_SDA_L;
   delay_us(2);
   I2C_SCL_H;
   delay_us(5);
   I2C_SCL_L;
}

//ӦźNACK
void I2C_NAck(void)
{
   I2C_SCL_L;
   I2C_SDA_OUT();
   I2C_SDA_H;
   delay_us(2);
   I2C_SCL_H;
   delay_us(5);
   I2C_SCL_L;
}
//ȴӻӦź
//ֵ1 Ӧʧ
//		  0 Ӧɹ
u8 I2C_Wait_Ack(void)
{
	u8 tempTime=0;
//I2C_SDA_H;
	//delay_us(1);
	//I2C_SCL_H;
	//delay_us(1);
	I2C_SDA_IN();
//I2C_SCL_H;
	I2C_SDA_H;
	delay_us(1);
	I2C_SCL_H;
	delay_us(1);

	while(GPIO_ReadInputDataBit(GPIO_I2C,I2C_SDA))
	{
		tempTime++;
		delay_us(1);
		if(tempTime>250)
		{
			I2C_StoP();
			return 1;
		}	 
	}
//I2C_SDA_OUT();
	//I2C_SDA_L;
	//I2C_SCL_H;
	//delay_us(1);
	I2C_SCL_L;
	delay_us(1);
	return 0;
}
//I2C һֽ
void I2C_Send_Byte(u8 txd)
{
	u8 i=0;

	I2C_SDA_OUT();
	I2C_SCL_L;//ʱӿʼݴ

	for(i=0;i<8;i++)
	{
		if((txd&0x80)>0) //0x80  1000 0000
			I2C_SDA_H;
		else
			I2C_SDA_L;

		txd<<=1;
		delay_us(1);
		I2C_SCL_H;
		delay_us(2); //
		I2C_SCL_L;
		delay_us(2);
	}
}

//I2C ȡһֽ

u8 I2C_Read_Byte(u8 ack)
{
   u8 i=0,receive=0;

   I2C_SDA_in();
   for(i=0;i<8;i++)
   {
   		I2C_SCL_L;
		delay_us(2);
		I2C_SCL_H;
		//while(!GPIO_ReadInputDataBit(GPIO_I2C,I2C_SCL));
		receive<<=1;
		if(GPIO_ReadInputDataBit(GPIO_I2C,I2C_SDA))
		   receive++;
		delay_us(1);	
   }

   	if(ack==0)
	   	I2C_NAck();
	else
		I2C_Ack();

	return receive;
}


void GXTS03_read_result(u8 addr)
{
	u16 tem,hum;
	//u16 tem1[8];
	u16 buff[6];
	float Temperature1[129]={0};
	float Temperature2=0;
	float Temperature=0;
	float Humidity=0;
	
	
	I2C_StarT();
	I2C_Send_Byte(addr<<1 | write);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
	I2C_Wait_Ack();
	I2C_Send_Byte(0x24);
	I2C_Wait_Ack();
	I2C_Send_Byte(0x16);
	I2C_Wait_Ack();
	I2C_StoP();
	delay_ms(5);//תʱ
	I2C_StarT();
	I2C_Send_Byte(addr<<1 | read);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
	if(I2C_Wait_Ack()==0)
	{
		I2C_SDA_in();
		
		
		//IIC_INPUT_MODE_SET();
		buff[0]=I2C_Read_Byte(1);
		//I2C_Ack();
		buff[1]=I2C_Read_Byte(1);
		//I2C_Ack();
		buff[2]=I2C_Read_Byte(1);
		//I2C_Ack();
		buff[3]=I2C_Read_Byte(1);
		//I2C_Ack();
		buff[4]=I2C_Read_Byte(1);
		//I2C_Ack();
		buff[5]=I2C_Read_Byte(0);
		//I2C_NAck();
		I2C_StoP();
		
	
	
	tem = ((buff[0]<<8) | buff[1]);//¶ƴ
	//hum = ((buff[3]<<8) | buff[4]);//ʪƴ
	
	/*תʵ¶*/
	Temperature= (175.0*(float)tem/65535.0-45.0) ;// T = -45 + 175 * tem / (2^16-1)
	//Humidity= (100.0*(float)hum/65535.0);// RH = hum*100 / (2^16-1)
	
}
	
	if((Temperature>=-20)&&(Temperature<=125)&&(Humidity>=0)&&(Humidity<=100))//˴
	{
		Humiture[0]=Temperature;
		//Humiture[2]=Humidity;
		//sprintf(Humiture_buff1,"%6.2f*C %6.2f%%",Temperature,Humidity);//111.01*C 100.01%2λС
		sprintf(Humiture_buff1,"%6.2f",Temperature);
	}
	    OLED_ShowCN(22+0*16,0,0);//ʾ
			OLED_ShowCN(22+1*16,0,1);//ʾ
		  OLED_ShowCN(22+2*16,0,2);//ʾ
			OLED_ShowCN(22+3*16,0,3);//ʾ
		  OLED_ShowCN(22+4*16,0,4);//ʾ
	
	    OLED_ShowCN(2,5,5);//ʾ
	    OLED_ShowCN(18,5,6);//ʾ
	    OLED_ShowStr(41,5,":",2);//6*8ַ
	    OLED_ShowStr(45,5,&Humidity,2);
		  OLED_ShowCN(100,5,7);//ʾ
	
		 // OLED_ShowStr(70,6,"'C",2);				//8*16ַ
	printf("¶ȣ%s\n\t\t",Humiture_buff1);
	hum=0;
	tem=0;
}
