



#include "gxt310.h"
#include "delay.h"
#include "usart.h"

/*******************************************************************************************************************************************************/
/*******************************************************IIC_IOڳʼ*************************************************************************************/
/*******************************************************************************************************************************************************/
void IIC_Init(void)
{	
		GPIO_InitTypeDef GPIO_InitStructure;
		RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA|RCC_APB2Periph_GPIOB,ENABLE);
		RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO,ENABLE);
		GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE); 
			 
		GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6|GPIO_Pin_7; 
		GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD ;   //©
		GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
		GPIO_Init(GPIOB, &GPIO_InitStructure);
		
		GPIO_SetBits(GPIOB,GPIO_Pin_6|GPIO_Pin_7); 
		
}

void IIC_SCL(uint8_t state) 
{
		if(state==0)       GPIO_ResetBits(GPIOB,GPIO_Pin_6);
		else if(state==1)  GPIO_SetBits(GPIOB,GPIO_Pin_6);
}
void IIC_SDA(uint8_t state) 
{
		if(state==0)       GPIO_ResetBits(GPIOB,GPIO_Pin_7);
		else if(state==1)  GPIO_SetBits(GPIOB,GPIO_Pin_7);
}
uint8_t READ_SDA(void)
{
		return GPIO_ReadInputDataBit(GPIOB,GPIO_Pin_7);
}

/*******************************************************************************************************************************************************/
/*******************************************************IICʱ*************************************************************************************/
/*******************************************************************************************************************************************************/
//IICʼź
void IIC_Start(void)
{
	IIC_SDA(1);	   	  
	IIC_SCL(1);
	delay_us(15);
 	IIC_SDA(0);
	delay_us(15);
	IIC_SCL(0);
}	  
//IICֹͣź
void IIC_Stop(void)
{
	IIC_SCL(0);
	IIC_SDA(0);
 	delay_us(15);
	IIC_SCL(1); 
	delay_us(15);
	IIC_SDA(1);
	delay_us(15);							   	
}
//ȴӦźŵ
//ֵ1Ӧʧ
//        0Ӧɹ

/*ȴӦȰsdasclߣ
  һֱΪ ˵ܵǷӦźţNACKߴʧܣ
  sdaΪ͵ƽյӦźţ
*/
uint8_t IIC_Wait_Ack(void)
{
	uint8_t ucErrTime=0;
	IIC_SDA(1);  
	IIC_SCL(1);delay_us(5);	 
	while(READ_SDA())
	{
		ucErrTime++;
		if(ucErrTime>1)
		{
			IIC_Stop();
			return 1;
		}
	}
	IIC_SCL(0);//ʱ0 	
	return 0;  
} 

//ACKӦ
void IIC_Ack(void)
{
	IIC_SCL(0);
	delay_us(5);
	IIC_SDA(0);
	delay_us(5);
	IIC_SCL(1);
	delay_us(5);
	IIC_SCL(0);
}

//ACKӦ		    
void IIC_NAck(void)
{
	IIC_SCL(0);
	delay_us(5);
	IIC_SDA(1);
	delay_us(5);
	IIC_SCL(1);
	delay_us(5);
	IIC_SCL(0);
}		
	
//IICһֽ
//شӻӦ
//1Ӧ
//0Ӧ			  
void IIC_Send_Byte(uint8_t txd)
{                        
    uint8_t t;    	    
    IIC_SCL(0);
    for(t=0;t<8;t++)
    {              
			if((txd&0x80)>>7)
				IIC_SDA(1);
			else
				IIC_SDA(0);
			txd<<=1; 	  
			delay_us(5);   
			IIC_SCL(1);
			delay_us(5); 
			IIC_SCL(0);	
			delay_us(5);
    }		
			IIC_SDA(1);
} 	

//1ֽڣack=1ʱACKack=0nACK   
uint8_t IIC_Read_Byte(unsigned char ack)
{
	unsigned char i,receive=0;
	IIC_SDA(1);
    for(i=0;i<8;i++ )
	  {
        IIC_SCL(0); 
        delay_us(5);
	    IIC_SCL(1);
        receive<<=1;
        if(READ_SDA())receive++;   
		delay_us(5); 
    }	
			
    if (!ack)   IIC_NAck();//nACK
    else        IIC_Ack(); //ACK   
    return receive;
}



/*******************************************************************************************************************************************************/
/*******************************************************GXT310д*************************************************************************************/
/*******************************************************************************************************************************************************/



//GXT310ָĴȡ
//w_addr   ӻַ(д)
//point_regĴַ
//r_addr   ӻַ()
uint16_t GXT310_Read_Register(uint8_t w_addr,uint8_t point_reg,uint8_t r_addr)
{
	u16 value=0,value1=0,value2=0;
    
    IIC_Start();
    delay_us(10);
    IIC_Send_Byte(w_addr);           IIC_Wait_Ack();    //ADDR
    delay_us(5);
    IIC_Send_Byte(point_reg);        IIC_Wait_Ack();        //pointer
    delay_us(5);
    IIC_Stop();
    delay_us(10);	

    
    IIC_Start();	
    delay_us(10);  
    IIC_Send_Byte(r_addr);           IIC_Wait_Ack();        //ADDR+1
    delay_us(5);
    value1 = IIC_Read_Byte(1);
    delay_us(5);
    value2 = IIC_Read_Byte(0);
    delay_us(10);
    IIC_Stop();
    value=value1;
    value=(value<<8)|value2;
	return value;
}




//GXT310ָĴд
//w_addr   ӻַ(д)
//point_regĴַ
//data1    д1
//data2    д2
void GXT310_Write_Register(uint8_t w_addr,uint8_t point_reg,uint8_t data1,uint8_t data2)
{
    IIC_Start();
    delay_us(10);
    IIC_Send_Byte(w_addr);           IIC_Wait_Ack();        //W_ADDR
    delay_us(5);
    IIC_Send_Byte(point_reg);        IIC_Wait_Ack();        //pointer
    delay_us(5);
    IIC_Send_Byte(data1);            IIC_Wait_Ack();        //data1
    delay_us(10);
    IIC_Send_Byte(data2);            IIC_Wait_Ack();        //data2
    delay_us(10);    
    IIC_Stop();
}




//ģʽ¶
void GET_GXT310_TEMP(void)
{

    int16_t temp;
    //¶
    temp = GXT310_Read_Register(GXT310_W_ADDR,0x00,GXT310_W_ADDR|0x01);    
    
    printf("\r\nTEMP_HEX = %#X",temp);   
    printf("\r\nTEMP = %f\r\n", temp*0.0078125);
}















