#ifndef __GXC400_H
#define __GXC400_H

#include "stm32f10x.h"
#include "math.h"
#include "delay.h"



/* GXC400ƿ */
#define GXC400_CONTROL_PORT     GPIOB
#define GXC400_SDO              GPIO_Pin_14
#define GXC400_CS               GPIO_Pin_12
#define GXC400_SCLK             GPIO_Pin_13
#define GXC400_SDI              GPIO_Pin_15
//#define GXC400_DRDY 	          GPIO_Pin_13 

#define GXC400_CS_SET           GPIO_WriteBit(GXC400_CONTROL_PORT,GXC400_CS,Bit_SET)
#define GXC400_CS_CLR      		  GPIO_WriteBit(GXC400_CONTROL_PORT,GXC400_CS,Bit_RESET)
#define GXC400_SCLK_SET    			GPIO_WriteBit(GXC400_CONTROL_PORT,GXC400_SCLK,Bit_SET)
#define GXC400_SCLK_CLR    			GPIO_WriteBit(GXC400_CONTROL_PORT,GXC400_SCLK,Bit_RESET)
#define GXC400_SDI_SET    			GPIO_WriteBit(GXC400_CONTROL_PORT,GXC400_SDI,Bit_SET)
#define GXC400_SDI_CLR     			GPIO_WriteBit(GXC400_CONTROL_PORT,GXC400_SDI,Bit_RESET)

#define GXC400_SDO_READ    			GPIO_ReadInputDataBit(GXC400_CONTROL_PORT,GXC400_SDO)
//#define GXC400_DRDY_READ   			GPIO_ReadInputDataBit(GXC400_CONTROL_PORT,GXC400_DRDY)

void GXC400_Init(void); //GXC400 ʼ,ģ
void GXC400_Cfg(void);  //GXC400 
float GXC400_GetTemp(void);//GXC400 ȡ¶
unsigned char GXC400_Read_Byte(unsigned char addr);
void GXC400_Write_Byte(unsigned char addr, unsigned char data);
void GXC400_Read_2Byte(unsigned char addr,unsigned char* MSB, unsigned char* LSB);


#endif

