#include "GXC400.h"

/***********************************************

˵GXC400 ʼ,ģ
************************************************/
void GXC400_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStructure ;

  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOC|RCC_APB2Periph_GPIOB|RCC_APB2Periph_GPIOA,ENABLE);

  GPIO_InitStructure.GPIO_Pin = GXC400_SCLK;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GXC400_CONTROL_PORT,&GPIO_InitStructure);

  GPIO_InitStructure.GPIO_Pin = GXC400_CS|GXC400_SCLK;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GXC400_CONTROL_PORT,&GPIO_InitStructure);

  GPIO_InitStructure.GPIO_Pin = GXC400_SDI;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GXC400_CONTROL_PORT,&GPIO_InitStructure);

  GPIO_InitStructure.GPIO_Pin = GXC400_SDO;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO_Init(GXC400_CONTROL_PORT,&GPIO_InitStructure);

  GXC400_CS_SET;
  //GXC400_SCLK_SET;
  GXC400_SCLK_CLR; //ʱΪ
}
/***********************************************
÷ʽGXC400_Write()
ֵ
˵GXC400 дĴ,addr:Ĵַ,data:
************************************************/
void GXC400_Write_Byte(unsigned char addr, unsigned char data)
{
  unsigned char i;

  GXC400_CS_CLR;
  for(i=0; i<8; i++) //дַ
    {
      GXC400_SCLK_SET;
      if(addr&0x80) GXC400_SDI_SET;
      else GXC400_SDI_CLR;
      GXC400_SCLK_CLR;
      addr<<=1;
    }
  for(i=0; i<8; i++) //д
    {
      GXC400_SCLK_SET;
      if(data&0x80) GXC400_SDI_SET;
      else GXC400_SDI_CLR;
      GXC400_SCLK_CLR;
      data<<=1;
    }
  GXC400_CS_SET;
}
/***********************************************
÷ʽGXC400_Read()
ֵ  data
˵GXC400 Ĵ ,addr:Ĵַ
************************************************/
unsigned char GXC400_Read_Byte(unsigned char addr)
{
  unsigned char i;
  unsigned char data=0;

  GXC400_CS_CLR;
  for(i=0; i<8; i++) //дַ
    {
      GXC400_SCLK_SET;
      if(addr&0x80) GXC400_SDI_SET;
      else GXC400_SDI_CLR;
      GXC400_SCLK_CLR;
      addr<<=1;
    }
  for(i=0; i<8; i++) //
    {
      GXC400_SCLK_SET;
      data<<=1;
      GXC400_SCLK_CLR;
      if(GXC400_SDO_READ) data|=0x01;
      else data|=0x00;
    }
  GXC400_CS_SET;
  return data;
}

void GXC400_Read_2Byte(unsigned char addr,unsigned char* MSB, unsigned char* LSB)
{
  unsigned char i;
  unsigned char DATA_MSB=0;
  unsigned char DATA_LSB=0;
  GXC400_CS_CLR;
  for(i=0; i<8; i++) //дַ
    {
      GXC400_SCLK_SET;
      if(addr&0x80) GXC400_SDI_SET;
      else GXC400_SDI_CLR;
      GXC400_SCLK_CLR;
      addr<<=1;
    }
  for(i=0; i<8; i++) //
    {
      GXC400_SCLK_SET;
      DATA_MSB<<=1;
      GXC400_SCLK_CLR;
      if(GXC400_SDO_READ) DATA_MSB|=0x01;
      else DATA_MSB|=0x00;
    }

  for(i=0; i<8; i++) //
    {
      GXC400_SCLK_SET;
      DATA_LSB<<=1;
      GXC400_SCLK_CLR;
      if(GXC400_SDO_READ) DATA_LSB|=0x01;
      else DATA_LSB|=0x00;
    }
  GXC400_CS_SET;
  *MSB = DATA_MSB;
  *LSB = DATA_LSB;

}
/***********************************************
÷ʽGXC400_Cfg()
ֵ
˵GXC400 
************************************************/
void GXC400_Cfg(void)
{
  //BIAS ON,Զ4ߣ50HZ  
  GXC400_Write_Byte(0x80, 0xC3);
}
/***********************************************
÷ʽGXC400_GetTemp()
ֵ
˵GXC400 ȡ¶
************************************************/
float GXC400_GetTemp(void)
{
  unsigned char MSB=0x00,LSB=0x00;
  unsigned int  RREF = 4000;  //PT10004000 PT100:400 
  unsigned int data;
  float Rt;
  float Rt0 = 1000;  //PT10001000 PT100:100
  float Z1,Z2,Z3,Z4,temp;
  float a = 3.9083e-3;
  float b = -5.775e-7;
  float rpoly;
  GXC400_Read_2Byte(0x01,&MSB,&LSB);
  data = MSB<<8|LSB;
  data>>=1;  //ȥFaultλ
  Rt=(float)data/32768.0*RREF;
  Z1 = -a;
  Z2 = a*a-4*b;
  Z3 = 4*b/Rt0;
  Z4 = 2*b;
  temp = Z2+Z3*Rt;
  temp = (sqrt(temp)+Z1)/Z4;
  if(temp>=0)
    {
      return temp;
    }
  rpoly = Rt;
  temp = -242.02;
  temp += 2.2228 * rpoly;
  rpoly *= Rt;  // square
  temp += 2.5859e-3 * rpoly;
  rpoly *= Rt;  // ^3
  temp -= 4.8260e-6 * rpoly;
  rpoly *= Rt;  // ^4
  temp -= 2.8183e-8 * rpoly;
  rpoly *= Rt;  // ^5
  temp += 1.5243e-10 * rpoly;

  return temp;
}





