

/*--------------------------------------------------------------------|
|                     !!!!!!!!!! NOTE !!!!!!!!!!                      |
|                                                                     |
|  The DQ port MUST be configured as open-drain output AT ALL TIMES   |
|--------------------------------------------------------------------*/

#include "gx1833e.h"

/*---------------------------------------------------------------------
  Function    : gx1833e_gpio_configure
  Description : configure the DQ port
  Parameter   : none
  Return      : none
---------------------------------------------------------------------*/
void gx1833e_gpio_configure (void)
{
    
  GPIO_InitTypeDef pin_cfg;
  // enable peripheral clock
  RCC_APB2PeriphClockCmd(GX1833e_GPIO_CLK, ENABLE);
	
  // configure I/O port of DQ

  pin_cfg.GPIO_Pin   = GX1833e_GPIO_PIN;
  pin_cfg.GPIO_Mode  = GPIO_Mode_Out_OD;	  // open-drain output
  pin_cfg.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GX1833e_GPIO_PORT, &pin_cfg);
	
	GPIO_SetBits(GX1833e_GPIO_PORT, GX1833e_GPIO_PIN);  // default HIGH
}

/*---------------------------------------------------------------------
  Function    : gx1833e_gpio_pulldown
  Description : pull down the 1-wire bus
  Parameter   : none
  Return      : none
---------------------------------------------------------------------*/
void gx1833e_gpio_pulldown (void)
{
  GPIO_ResetBits(GX1833e_GPIO_PORT, GX1833e_GPIO_PIN);
}

/*---------------------------------------------------------------------
  Function    : gx1833e_gpio_release
  Description : release the 1-wire bus
  Parameter   : none
  Return      : none
---------------------------------------------------------------------*/
void gx1833e_gpio_release (void)
{
  GPIO_SetBits(GX1833e_GPIO_PORT, GX1833e_GPIO_PIN);
}

/*---------------------------------------------------------------------
  Function    : gx1833e_gpio_sample
  Description : sample the 1-wire bus
  Parameter   : none
  Return      : sampled data
---------------------------------------------------------------------*/
uint8_t gx1833e_gpio_sample (void)
{
	return GPIO_ReadInputDataBit(GX1833e_GPIO_PORT, GX1833e_GPIO_PIN);
}

