

#ifndef __GX1833E_DRIVER_HEADER_FILE
#define __GX1833E_DRIVER_HEADER_FILE

#include "sys.h"  

// CRC-8 generator polynomial
#define CRC_POLY                 0x8C


// definition of addressing command
#define GX1833E_SEARCH                0xF0
#define GX1833E_ALARM                 0xEC
#define GX1833E_READ                  0x33
#define GX1833E_MATCH                 0x55
#define GX1833E_SKIP                  0xCC

#define GX1833E_SEARCH_UID            0xF8
#define GX1833E_ALARM_SEARCH_UID      0xF4
#define GX1833E_MATCH_UID             0x22

// definition of function command
#define GX1833E_CONVERT               0x44
#define GX1833E_READ_SCRATCHPAD       0xBE
#define GX1833E_WRITE_SCRATCHPAD      0x4E
#define GX1833E_RESET                 0xB8
#define GX1833E_Erase_Memory          0xC1
#define GX1833E_Read_Memory           0xF0
#define GX1833E_Write_Memory          0xC5


#define MAX_NUM 16

// function declaration
uint8_t gx1833e_search_uid (uint32_t * ids);
uint8_t gx1833e_alarm_search_uid (uint32_t * ids);
uint8_t gx1833e_match_uid (uint32_t uid);



uint8_t gx1833e_generate_crc8 (uint64_t dat, uint8_t crc_reg_init);

uint64_t gx1833e_read_scratchpad (void);
uint64_t gx1833e_VerifyRead_EE  (uint8_t mode, uint8_t addr);
void gx1833e_Read_EE  (uint8_t addr, uint8_t block);
void gx1833e_Program_EE  (uint8_t addr, uint8_t block, uint64_t *array);
void gx1833e_Program_EE_block  (uint8_t addr, uint64_t data);
// function declaration
uint8_t  gx1833e_search           (uint64_t * ids);
uint8_t  gx1833e_alarm            (uint64_t * ids);
uint64_t gx1833e_read_rom         (void);
uint8_t  gx1833e_match            (uint64_t   id);
uint8_t  gx1833e_skip             (void);
void     gx1833e_convert          (void);



#endif


