#ifndef __gx122_H
#define __gx122_H

#include "stm32f10x.h"
#include "./systick/bsp_SysTick.h"
#include "stdio.h"

#define SPI_PORT    		GPIOA		              /* GPIO˿ */
#define SPI_CLK 	   		RCC_APB2Periph_GPIOA		/* GPIO˿ʱ */
#define SOI_PIN					GPIO_Pin_2
#define SCK_PIN					GPIO_Pin_3
#define CS_PIN					GPIO_Pin_7





#define SCK(bit)				GPIO_WriteBit(SPI_PORT,SCK_PIN,bit ? Bit_SET:Bit_RESET )
#define SOI_OUT(bit)		GPIO_WriteBit(SPI_PORT,SOI_PIN,bit ? Bit_SET:Bit_RESET )
#define CS0(bit)				GPIO_WriteBit(SPI_PORT,CS_PIN,bit ? Bit_SET:Bit_RESET )
#define SOI_IN() 				GPIO_ReadInputDataBit (GPIOA,GPIO_Pin_2)
#define SOI_IO_IN() 		GX122_Mode_IPU()
#define SOI_IO_OUT() 		GX122_Mode_Out_PP()
 

//ʼ
void FTInit(void);
//¶
void spiReadTemp(void);


static void GX122_Mode_IPU(void);
static void GX122_Mode_Out_PP(void);


#endif

