#include "GX112x.h"
#include "delay.h"
#include "al_debug.h"

#define write 0
#define read  1

u8 Temperature_buff[20];

/****************************************************************************
* Function Name  : IIC_Config
* Description    : ʼGPIO.
* Input          : None
* Output         : None
* Return         : None
****************************************************************************/
void I2C_INIT()
{
    GPIO_InitTypeDef GPIO_InitStructure;

    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA,ENABLE);
    GPIO_InitStructure.GPIO_Pin=I2C_SDA;
    GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA,&GPIO_InitStructure);

    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA,ENABLE);
    GPIO_InitStructure.GPIO_Pin=I2C_SCL;
    GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA,&GPIO_InitStructure);

    I2C_SCL_H;
    I2C_SDA_H;
}

/*******************************************************************************
*            : I2C_SDA_OUT
* 		   : SDA
*              : 
*              : 
*******************************************************************************/
void I2C_SDA_OUT()
{
    GPIO_InitTypeDef GPIO_InitStructure;

    GPIO_InitStructure.GPIO_Pin=I2C_SDA;
    GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA,&GPIO_InitStructure);
}

void I2C_SDA_in(void)
{
    GPIO_InitTypeDef GPIO_InitStructure;

    GPIO_InitStructure.GPIO_Pin=I2C_SDA;
    GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA,&GPIO_InitStructure);
}

//IIC1  ʼź
void I2C_StarT(void)
{
    I2C_SDA_OUT();

    I2C_SDA_H;
    I2C_SCL_H;
    delay_us(5);
    I2C_SDA_L;
    delay_us(6);
    I2C_SCL_L;
}


//IIC1 ֹͣź
void I2C_StoP(void)
{
    I2C_SDA_OUT();

    I2C_SCL_L;
    I2C_SDA_L;
    I2C_SCL_H;
    delay_us(6);
    I2C_SDA_H;
    delay_us(6);
}

//IIC1 ӦźACK
void I2C_Ack(void)
{
    I2C_SCL_L;
    I2C_SDA_OUT();
    I2C_SDA_L;
    delay_us(2);
    I2C_SCL_H;
    delay_us(5);
    I2C_SCL_L;
}

//IIC1 ӦźNACK
void I2C_NAck(void)
{
    I2C_SCL_L;
    I2C_SDA_OUT();
    I2C_SDA_H;
    delay_us(2);
    I2C_SCL_H;
    delay_us(5);
    I2C_SCL_L;
}



//IIC1 ȴӻӦź
//ֵ1 Ӧʧ
//		  0 Ӧɹ
u8 I2C_Wait_Ack(void)
{
    u8 tempTime=0;

    I2C_SDA_in();

    I2C_SDA_H;
    delay_us(1);
    I2C_SCL_H;
    delay_us(1);

    while(GPIO_ReadInputDataBit(GPIO_I2C,I2C_SDA))
    {
        tempTime++;
        delay_us(1);
        if(tempTime>250)
        {
            I2C_StoP();
            return 1;
        }
    }

    I2C_SCL_L;
    delay_us(1);
    return 0;
}


//I2C1 һֽ
void I2C_Send_Byte(u8 txd)
{
    u8 i=0;
    I2C_SDA_OUT();
    I2C_SCL_L;//ʱӿʼݴ
    for(i=0; i<8; i++)
    {
        if((txd&0x80)>0) //0x80  1000 0000
            I2C_SDA_H;
        else
            I2C_SDA_L;
        txd<<=1;
        delay_us(1);
        I2C_SCL_H;
        delay_us(2); //
        I2C_SCL_L;
        delay_us(2);
    }
}


//I2C1 ȡһֽ
u8 I2C_Read_Byte(u8 ack)
{
    u8 i=0,receive=0;
    I2C_SDA_in();
    for(i=0; i<8; i++)
    {
        I2C_SCL_L;
        delay_us(2);
        I2C_SCL_H;
        receive<<=1;
        if(GPIO_ReadInputDataBit(GPIO_I2C,I2C_SDA))
            receive++;
        delay_us(1);
    }
    if(ack==0)
        I2C_NAck();
    else
        I2C_Ack();
    return receive;
}


void GX112_read_result(u8 addr)
{
    short tem,hum;

    u8 buff[6];
    float Temperature=0;

    I2C_StarT();
    I2C_Send_Byte(addr <<1 | write);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
    I2C_Wait_Ack();
    I2C_Send_Byte(0x00);
    I2C_Wait_Ack();

		delay_us(20);
	
    I2C_StarT();
    I2C_Send_Byte(addr <<1 | read);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
    
		if(I2C_Wait_Ack()==0)
    {
        buff[0]=I2C_Read_Byte(1);
        buff[1]=I2C_Read_Byte(0);

        I2C_StoP();

    }
    else
    {
        buff[0]=0;
        buff[1]=0;
        I2C_StoP();
    }
	
    if(buff[0]&0x80)
    {
        tem=(buff[0] << 8) | buff[1] ;
        hum = (((~tem)>>4)+1)&0x0fff;
        Temperature=-(float)(hum*0.0625);
    }
    else
    {
        tem=(buff[0] << 8) | buff[1] ;
        hum = tem>>4;
        Temperature=(float)(hum*0.0625);
    }

    sprintf((char *)Temperature_buff,"addr_0x%x,temperature:%3.2f",addr,Temperature);//111.01*C 100.01%2λС
	
    al_debug_log("%s",Temperature_buff);

    tem=0;
    hum=0;

}

void Low_PowerDesign(u8 slave_addr)
{
    I2C_StarT();
    I2C_Send_Byte(slave_addr <<1 | write);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
    I2C_Wait_Ack();
    
		I2C_Send_Byte(0x01);
    I2C_Wait_Ack();
		I2C_Send_Byte(0x01);
    I2C_Wait_Ack();
		I2C_Send_Byte(0x80);
		I2C_Wait_Ack();
		I2C_StoP();
}

void Quit_low_PowerDesign(unsigned char slave_addr)
{
   I2C_StarT();
    I2C_Send_Byte(slave_addr <<1 | write);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
    I2C_Wait_Ack();
    
		I2C_Send_Byte(0x01);
    I2C_Wait_Ack();
		I2C_Send_Byte(0x00);
    I2C_Wait_Ack();
		I2C_Send_Byte(0x80);
		I2C_Wait_Ack();
		I2C_StoP();
}

void One_Shot_PowerDesign(unsigned char slave_addr)
{
    I2C_StarT();
    I2C_Send_Byte(slave_addr <<1 | write);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
    I2C_Wait_Ack();
    
		I2C_Send_Byte(0x01);
    I2C_Wait_Ack();
		I2C_Send_Byte(0x80);
    I2C_Wait_Ack();
		I2C_Send_Byte(0x80);
		I2C_Wait_Ack();
		I2C_StoP();
}

//DMA оƬȡ
void W_3BYTE_112x(unsigned char slave_addr, unsigned char register_addr, unsigned char MSB, unsigned char LSB)  // W_3BYTE_112x_LR(0x00,0x00,0x00,0x01);
{

    I2C_StarT();
    I2C_Send_Byte(slave_addr + 0); // ADDR:0X00
    I2C_Wait_Ack();

    I2C_Send_Byte(register_addr);
    I2C_Wait_Ack();

    I2C_Send_Byte(MSB);						//0x00
    I2C_Wait_Ack();

    I2C_Send_Byte(LSB);						//0x01
    I2C_Wait_Ack();

    delay_ms(1);
    I2C_StoP();
}

////DMA оƬȡ
void R_3BYTE_112x(unsigned char slave_addr, unsigned char register_addr)
{
		unsigned char buff[10];
		short tem1,hum1,tem2,hum2,tem3,hum3;
	
		float Temperature1 = 0, Temperature2 = 0, Temperature3 = 0;
	
    I2C_StarT();
    I2C_Send_Byte(slave_addr + 0); // ADDR:0X00
    I2C_Wait_Ack();
    I2C_Send_Byte(register_addr);
    I2C_Wait_Ack();
    I2C_StoP();

		delay_ms(5);
	
    I2C_StarT();
    I2C_Send_Byte(slave_addr + 1); // ADDR:0X00
	
		if(I2C_Wait_Ack()==0)
    {
        buff[0]=I2C_Read_Byte(1);//XA
        buff[1]=I2C_Read_Byte(1);
			
				buff[2]=I2C_Read_Byte(1);//XB
        buff[3]=I2C_Read_Byte(1);
			
				buff[4]=I2C_Read_Byte(1);//XC
        buff[5]=I2C_Read_Byte(1);
			
				buff[6]=I2C_Read_Byte(1);//XD
        buff[7]=I2C_Read_Byte(1);
			
				buff[8]=I2C_Read_Byte(1);//XE
        buff[9]=I2C_Read_Byte(0);

        I2C_StoP();
    }
    else
    {
        buff[0]=0;
        buff[1]=0;
				buff[2]=0;
        buff[2]=0;
				buff[4]=0;
        buff[5]=0;
				buff[6]=0;
        buff[7]=0;
				buff[8]=0;
        buff[9]=0;
        I2C_StoP();
    }
	
    if(buff[0]&0x80)
    {
        tem1 = (buff[0] << 8) | buff[1] ;
        hum1 = (((~tem1)>>4)+1)&0x0fff;
        Temperature1 = -(float)(hum1 *0.0625);
			
				tem2 = (buff[6] << 8) | buff[7] ;
        hum2 = (((~tem2)>>4)+1)&0x0fff;
        Temperature2 = -(float)(hum2 *0.0625);
					
				tem3 = (buff[8] << 8) | buff[9] ;
        hum3 = (((~tem3)>>4)+1)&0x0fff;
        Temperature3 = -(float)(hum3 *0.0625);
    }
    else
    {
        tem1 = (buff[0] << 8) | buff[1] ;
        hum1 = tem1 >>4;
        Temperature1 =(float)(hum1 * 0.0625);
			
				tem2 = (buff[6] << 8) | buff[7] ;
        hum2 = tem2 >>4;
        Temperature2 =(float)(hum2 * 0.0625);
			
				tem3 = (buff[8] << 8) | buff[9] ;
        hum3 = tem3 >>4;
        Temperature3 =(float)(hum3 * 0.0625);
    }
		
		al_debug_log("¶1%.1f,¶2%.1f,¶3%.1f",Temperature1,Temperature2,Temperature3);
}




#if 0
int main(void)
{	
	Hardware_Init();
	
	while(1)
	{
		GX112_read_result1(0x41);
	}
}
#endif






